<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('interview_answers', function (Blueprint $table) {
            $table->unsignedBigInteger('Interview_answer_id')->autoIncrement();
            $table->unsignedBigInteger('Interview_id');
            $table->unsignedBigInteger('Question_id');
            $table->text('Answer_text');
            $table->decimal('Score', 5, 2)->nullable();
            $table->text('Feedback')->nullable();
            $table->timestamp('Created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->foreign('Interview_id', 'interview_answers_interview_id_foreign')->references('Interview_id')->on('interview_attempts')->onDelete('cascade');
            $table->foreign('Question_id', 'interview_answers_question_id_foreign')->references('Interview_question_id')->on('interview_questions')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('interview_answers');
    }
};
